/*
 * Decompiled with CFR 0.152.
 */
package SNMPConnector;

import java.io.IOException;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;

public class SNMPConnector_manager {
    Snmp snmp = null;
    String address = null;

    public SNMPConnector_manager(String add) {
        this.address = add;
    }

    void start() throws IOException {
        DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
        this.snmp = new Snmp((TransportMapping)transport);
        transport.listen();
    }

    public String getAsString(OID oid) throws IOException {
        ResponseEvent event = this.get(new OID[]{oid});
        String result = null;
        try {
            result = event.getResponse().get(0).getVariable().toString();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        return result;
    }

    public ResponseEvent get(OID[] oids) throws IOException {
        PDU pdu = new PDU();
        for (OID oid : oids) {
            pdu.add(new VariableBinding(oid));
        }
        pdu.setType(-96);
        ResponseEvent event = this.snmp.send(pdu, this.getTarget(), null);
        if (event != null) {
            return event;
        }
        throw new RuntimeException("GET timed out");
    }

    Target getTarget() {
        Address targetAddress = GenericAddress.parse((String)this.address);
        CommunityTarget target = new CommunityTarget();
        target.setCommunity(new OctetString("public"));
        target.setAddress(targetAddress);
        target.setRetries(2);
        target.setTimeout(1500L);
        target.setVersion(0);
        return target;
    }
}

